<?php

$features = array(
	array(
		'title'       => __( 'Ready calculator templates', 'cost-calculator-builder' ),
		'description' => __( 'With hundreds of calculator templates to choose from, you can find the perfect fit for your business. So you can create customized forms quickly and easily.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-page',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/getting-started/importing-demos',
	),
	array(
		'title'       => __( 'Orders dashboard', 'cost-calculator-builder' ),
		'description' => __( 'Manage orders and view payment details for paid ones on the dashboard. Track, operate, and confirm your customers’ orders.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-order-list',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/pro-plugin-features/orders',
	),
	array(
		'title'       => __( 'Conditional system', 'cost-calculator-builder' ),
		'description' => __( 'Create detailed and practical forms with fields that adapt based on conditions. Your customers interact only with what they need.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-schema',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/conditional-system/introduction',
	),
	array(
		'title'       => __( 'Discounts feature', 'cost-calculator-builder' ),
		'description' => __( 'Set up discounts and create promo codes for your customers. Choose start and end dates for sales and run limited or ongoing discounts.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-Sale-Discount',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/pro-plugin-features/discounts',
	),
	array(
		'title'       => __( 'Order form', 'cost-calculator-builder' ),
		'description' => __( 'Create order forms in your calculator. They can get more information about your clients by filling in the form.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-order-detail',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/pro-plugin-features/send-form',
	),
	array(
		'title'       => __( 'Stripe integration', 'cost-calculator-builder' ),
		'description' => __( 'Accept payments seamlessly with Stripe. Cost Calculator ensures secure and convenient transactions for you and your customers.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-stripe-s',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/pro-plugin-features/stripe',
	),
	array(
		'title'       => __( 'PayPal integration', 'cost-calculator-builder' ),
		'description' => __( 'Accept payments seamlessly with PayPal. Cost Calculator ensures secure and convenient transactions for you and your customers.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-paypal-p',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/pro-plugin-features/paypal',
	),
	array(
		'title'       => __( 'Page breaker', 'cost-calculator-builder' ),
		'description' => __( 'Create step-by-step calculators and break down the calculator into several pages. This makes navigation for users easier.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-page-break',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/calculator-elements/page-breaker-pro-feature',
	),
	array(
		'title'       => __( 'Sticky calculator', 'cost-calculator-builder' ),
		'description' => __( 'Add a floating button or a sticky banner to make viewing the calculator on your pages more engaging for users.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-sticky-calc',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/pro-plugin-features/sticky-calculator',
	),
	array(
		'title'       => __( 'Date picker element', 'cost-calculator-builder' ),
		'description' => __( 'Add a date picker element to your calculator. And let your customers add important dates and date ranges to their calculations.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-date-picker',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/calculator-elements/date-picker-pro-feature',
	),
	array(
		'title'       => __( 'Time picker element', 'cost-calculator-builder' ),
		'description' => __( 'Add a time picker element to your calculator. And let your customers choose the time for their appointments.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-time-picker',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/calculator-elements/time-picker-pro-feature',
	),
	array(
		'title'       => __( 'Geolocation element', 'cost-calculator-builder' ),
		'description' => __( 'Let your customers use their current location or choose start and end points to calculate distance and cost.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-location',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/calculator-elements/geolocation-pro-feature',
	),
	array(
		'title'       => __( 'Multi range element', 'cost-calculator-builder' ),
		'description' => __( 'Add a Multi Range element and give different ranges independently. Give your customers more flexibility in their calculations.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-multi-range',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/calculator-elements/multi-range',
		'icon_size'   => 'font-size: 23px;',
	),
	array(
		'title'       => __( 'Repeater element', 'cost-calculator-builder' ),
		'description' => __( 'Let your customers calculate costs for several items or people in a single form with a Repeater element.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-reload',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/calculator-elements/repeater-pro-feature',
	),
	array(
		'title'       => __( 'Group element', 'cost-calculator-builder' ),
		'description' => __( 'Add a group field element to your calculator. It lets you group fields together, show them based on user input, and make forms more interactive.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-group-element',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/calculator-elements/group-field-pro-feature',
	),
	array(
		'title'       => __( 'File upload element', 'cost-calculator-builder' ),
		'description' => __( 'Add a File upload element to set a module where the users may attach any type of file onto the calculator.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-upload',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/calculator-elements/file-upload',
	),
	array(
		'title'       => __( 'Validated form element', 'cost-calculator-builder' ),
		'description' => __( 'Set guidelines for user data entry to ensure correct formatting and accurate calculations for fields like name, email, and URL.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-phone-solid',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/calculator-elements/validated-form',
	),
	array(
		'title'       => __( 'Image dropdown element', 'cost-calculator-builder' ),
		'description' => __( 'Add an Image dropdown element and engage the users by placing the dropdown with a set of images.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-picture',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/calculator-elements/drop-down-with-image',
	),
	array(
		'title'       => __( 'Several forms on a page', 'cost-calculator-builder' ),
		'description' => __( 'Create several calculators on any page of your website. With this, you can give more tailored experiences for your users.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-several',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/plugin-features/insert-calculators-into-the-page',
	),
	array(
		'title'       => __( 'PDF entries', 'cost-calculator-builder' ),
		'description' => __( 'Let your customers get a detailed invoice with costs for services after the calculation. They will be able to download, print, or send an invoice via email.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-pdf-lite',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/pro-plugin-features/pdf-entries',
	),
	array(
		'title'       => __( 'Custom webhooks', 'cost-calculator-builder' ),
		'description' => __( 'Let your website do things automatically so you save lots of time and effort. Make apps or services share information with calculator webhooks in real time.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-Webhooks',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/pro-plugin-features/custom-webhooks',
	),
	array(
		'title'       => __( 'Backup & changes restore', 'cost-calculator-builder' ),
		'description' => __( 'Enable automatic backup and restore changes made in your calculator.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-History',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/pro-plugin-features/automatic-backup',
	),
	array(
		'title'       => __( 'Auto backup (last 3 saves)', 'cost-calculator-builder' ),
		'description' => __( 'You can restore the last changes in case of any mistakes. Back up the last three saves in the calculator.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-History',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/pro-plugin-features/automatic-backup',
	),
	array(
		'title'       => __( 'reCaptcha', 'cost-calculator-builder' ),
		'description' => __( 'Ensure the security and reject internet bots by enabling ReCaptcha. Add a popular service providing anti-abuse security to protect your website.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-shield',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/pro-plugin-features/recaptcha',
	),
	array(
		'title'       => __( 'WooCommerce checkout', 'cost-calculator-builder' ),
		'description' => __( 'Seamlessly integrate your site with WooCommerce. Cost Calculator ensures secure and convenient transactions for you and your customers.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-woo',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/pro-plugin-features/woo-checkout',
		'icon_size'   => 'font-size: 25px;',
	),
	array(
		'title'       => __( 'Contact Form 7', 'cost-calculator-builder' ),
		'description' => __( 'Enhance functionality by integrating with Contact Form 7. This integration helps you create the best customer experience.', 'cost-calculator-builder' ),
		'icon'        => 'ccb-icon-seven',
		'link'        => 'https://docs.stylemixthemes.com/cost-calculator-builder/pro-plugin-features/send-form/contact-form-7-plugin',
	),
);

$support_url  = 'https://support.stylemixthemes.com/tickets/new/support?item_id=29';
$current_page = isset( $_GET['page'] ) ? sanitize_text_field( $_GET['page'] ) : 'cost_calculator_orders'; // phpcs:ignore WordPress.Security.NonceVerification
$current_page = isset( $_GET['tab'] ) && sanitize_text_field( $_GET['tab'] ) === 'settings' ? 'cost_calculator_builder_settings' : $current_page; // phpcs:ignore WordPress.Security.NonceVerification
$header_pages = array(
	'calculators' => array(
		'icon'  => 'ccb-icon-Union-18',
		'link'  => get_admin_url() . 'admin.php?page=cost_calculator_builder',
		'title' => __( 'Calculators', 'cost-calculator-builder' ),
		'key'   => 'cost_calculator_builder',
	),
	'orders'      => array(
		'icon'  => 'ccb-icon-Union-17',
		'link'  => get_admin_url() . 'admin.php?page=cost_calculator_orders',
		'title' => __( 'Orders', 'cost-calculator-builder' ),
		'key'   => 'cost_calculator_orders',
	),
	'settings'    => array(
		'icon'  => 'ccb-icon-Union-28',
		'link'  => get_admin_url() . 'admin.php?page=cost_calculator_builder&tab=settings',
		'title' => __( 'Global Settings', 'cost-calculator-builder' ),
		'key'   => 'cost_calculator_builder_settings',
	),
	'account'     => null,
);

?>



<div class="ccb-pro-features-container">
	<div class="ccb-pro-features-header">
		<div class="ccb-header">
			<div class="ccb-header-left">
				<span class="ccb-header-logo">
					<img src="<?php echo esc_attr( CALC_URL . '/frontend/dist/img/calc.svg' ); ?>" alt="Cost Calculator">
				</span>
				<span class="ccb-header-title-box">
					<span class="ccb-header-title"><?php esc_html_e( 'Cost Calculator', 'cost-calculator-builder' ); ?></span>
					<span class="ccb-header-version">
						<?php esc_html_e( 'Version', 'cost-calculator-builder' ); ?><?php echo esc_html( sprintf( '  %s', CALC_VERSION ) ); ?>
					</span>
				</span>
			</div>
			<div class="ccb-header-right">
				<span class="ccb-header-navigation">
					<?php foreach ( $header_pages as $h_page ) : ?>
						<?php if ( ! empty( $h_page ) ) : ?>
							<a class="ccb-header-nav <?php echo esc_attr( $current_page === $h_page['key'] ? 'active' : '' ); ?>" href="<?php echo esc_url( $h_page['link'] ); ?>">
								<i class="<?php echo esc_attr( $h_page['icon'] ); ?>"></i>
								<?php echo esc_html( $h_page['title'] ); ?>
							</a>
						<?php endif; ?>
					<?php endforeach; ?>
				</span>
				<span class="ccb-header-link">
					<?php if ( ! defined( 'CCB_PRO' ) ) : ?>
						<a href="<?php echo esc_url( get_admin_url() . 'admin.php?page=cost_calculator_gopro' ); ?>" target="_blank" class="btn-upgrade">
							<i class="ccb-icon-Path-3496"></i>
							<?php esc_html_e( 'Upgrade', 'cost-calculator-builder' ); ?>
						</a>
					<?php endif; ?>
				</span>
			</div>
		</div>
	</div>

	<div class="ccb-pro-features-body">
		<div class="ccb-pro-features-action-block">
			<div class="ccb-pro-features-action-block__title">
				<span class="green"><?php echo esc_html__( 'Unlock all pro features', 'cost-calculator-builder' ); ?></span>
				<?php echo esc_html__( 'with', 'cost-calculator-builder' ); ?> <br>
				<span class="black"><?php echo esc_html__( 'Cost Calculator Pro!', 'cost-calculator-builder' ); ?></span>
			</div>
			<div class="ccb-pro-features-action-block__features">
				<div class="ccb-pro-features-action-block__feature">
					<div class="icon">
						<i class="ccb-icon-pazzle"></i>
					</div>
					<div class="label">
						<?php esc_html_e( 'Premium features', 'cost-calculator-builder' ); ?>
					</div>
				</div>
				<div class="ccb-pro-features-action-block__feature">
					<div class="icon">
						<i class="ccb-icon-cloud"></i>
					</div>
					<div class="label">
						<?php esc_html_e( 'Frequent updates', 'cost-calculator-builder' ); ?>
					</div>
				</div>
				<div class="ccb-pro-features-action-block__feature">
					<div class="icon">
						<i class="ccb-icon-support"></i>
					</div>
					<div class="label">
						<?php esc_html_e( 'Priority ticket support', 'cost-calculator-builder' ); ?>
					</div>
				</div>
			</div>
			<div class="ccb-pro-features-action-block__button">
				<a href="<?php echo esc_url( home_url() ); ?>/wp-admin/admin.php?page=cost_calculator_gopro&from=pro-features-page&utm_source=wpadmin-ccb&utm_medium=get-now-button&utm_campaign=cost-calculator-pro">
					<i class="ccb-icon-Arrow-Previous"></i>
					<span><?php esc_html_e( 'Get Now', 'cost-calculator-builder' ); ?></span>
				</a>
			</div>
		</div>
		<div class="ccb-pro-features-list">
			<?php foreach ( $features as $feature ) : ?>
				<div class="ccb-pro-features-block">
					<div class="ccb-pro-features-block__icon">
					<span style="<?php echo isset( $feature['icon_size'] ) ? esc_attr( $feature['icon_size'] ) : ''; ?>">
						<i class="<?php echo esc_attr( $feature['icon'] ); ?>"></i>
					</span>
					</div>
					<div class="ccb-pro-features-block__main">
						<div class="ccb-pro-features-block__title">
							<?php echo esc_html( $feature['title'] ); ?>
						</div>
						<div class="ccb-pro-features-block__description">
							<?php echo esc_html( $feature['description'] ); ?>
						</div>
						<div class="ccb-pro-features-block__link">
							<a href="<?php echo esc_url( $feature['link'] ); ?>" target="_blank">
								<span>
									<?php esc_html_e( 'How it works', 'cost-calculator-builder' ); ?>
								</span>
								<i class="ccb-icon-circle-question"></i>
							</a>
						</div>
					</div>
				</div>
			<?php endforeach; ?>
			<div class="ccb-pro-features-block soon">
				<span><?php esc_html_e( 'More Features Coming Soon' ); ?></span>
			</div>
		</div>
		<div class="ccb-pro-features-action-block">
			<div class="ccb-pro-features-action-block__title">
				<span class="green"><?php echo esc_html__( 'Unlock all pro features', 'cost-calculator-builder' ); ?></span>
				<?php echo esc_html__( 'with', 'cost-calculator-builder' ); ?> <br>
				<span class="black"><?php echo esc_html__( 'Cost Calculator Pro!', 'cost-calculator-builder' ); ?></span>
			</div>
			<div class="ccb-pro-features-action-block__features">
				<div class="ccb-pro-features-action-block__feature">
					<div class="icon">
						<i class="ccb-icon-pazzle"></i>
					</div>
					<div class="label">
						<?php esc_html_e( 'Premium features', 'cost-calculator-builder' ); ?>
					</div>
				</div>
				<div class="ccb-pro-features-action-block__feature">
					<div class="icon">
						<i class="ccb-icon-cloud"></i>
					</div>
					<div class="label">
						<?php esc_html_e( 'Frequent updates', 'cost-calculator-builder' ); ?>
					</div>
				</div>
				<div class="ccb-pro-features-action-block__feature">
					<div class="icon">
						<i class="ccb-icon-support"></i>
					</div>
					<div class="label">
						<?php esc_html_e( 'Priority ticket support', 'cost-calculator-builder' ); ?>
					</div>
				</div>
			</div>
			<div class="ccb-pro-features-action-block__button">
				<a href="#">
					<i class="ccb-icon-Arrow-Previous"></i>
					<span><?php esc_html_e( 'Get Now', 'cost-calculator-builder' ); ?></span>
				</a>
			</div>
		</div>
	</div>
</div>
